/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWSchema;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.Icon;

public class VWXMLSchemaTableModel
extends VWBaseFieldTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_SCHEMA = 2;
    private String m_tempSchema = "";

    public VWXMLSchemaTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWSchema schema;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (schema = (VWSchema)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteSchema(schema.getName());
                    this.m_authPropertyData.resetSchemaCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(schema);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 549);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void copyItem(int nRowIndex) {
        block4: {
            try {
                VWSchema schema;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && (schema = (VWSchema)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String copyOfString = VWResource.s_copyOfFieldName.toString(schema.getName());
                    VWSchema newSchema = this.m_authPropertyData.getWorkflowDefinition().createSchema(copyOfString);
                    if (newSchema != null) {
                        newSchema.setSchema(schema.getSchema());
                        this.m_authPropertyData.resetSchemaCache();
                        this.m_authPropertyData.setDirty();
                        this.m_rowData.addElement(new VWTableItemWrapper(0, newSchema));
                        nRowIndex = this.getRowCount() - 2;
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(newSchema);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 547);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block4;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reinitialize() {
        try {
            try {
                super.reinitialize();
                if (this.m_authPropertyData != null) {
                    int i;
                    VWSchema[] schema;
                    if (this.m_authPropertyData.getShowInheritedProperties() && (schema = this.m_authPropertyData.getSchemas(2)) != null) {
                        for (i = 0; i < schema.length; ++i) {
                            this.m_rowData.addElement(new VWTableItemWrapper(1, schema[i]));
                        }
                    }
                    if ((schema = this.m_authPropertyData.getSchemas(1)) != null) {
                        for (i = 0; i < schema.length; ++i) {
                            int nIndex = this.findIndex(schema[i].getName());
                            if (nIndex != -1) {
                                this.overrideTableItem(nIndex, schema[i]);
                                continue;
                            }
                            this.m_rowData.addElement(new VWTableItemWrapper(0, schema[i]));
                        }
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWSchema vwSchema;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (vwSchema = (VWSchema)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = vwSchema.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_definition;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWSchema schema = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null) {
                schema = (VWSchema)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (schema == null) break;
                    return schema.getName();
                }
                case 2: {
                    if (schema != null) {
                        return schema.getSchema();
                    }
                    return this.m_tempSchema;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: 
            case 2: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.onUpdateName(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateSchema(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block9: {
            VWSchema vwSchema = null;
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newName = (String)aValue;
                if (newName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    vwSchema = (VWSchema)wrapper.getValue();
                }
                if (vwSchema != null) {
                    String oldName = vwSchema.getName();
                    vwSchema.setName(newName);
                    this.m_authPropertyData.setDirty();
                    this.fireTableCellUpdated(nRowIndex, 1);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(oldName);
                    this.m_changedItems.addElement(newName);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 548);
                } else {
                    if (this.m_authPropertyData.getSchema(newName) != null) {
                        String message = VWResource.s_schemaExists.toString(newName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    vwSchema = this.m_authPropertyData.getWorkflowDefinition().createSchema(newName);
                    if (vwSchema != null) {
                        vwSchema.setSchema(this.m_tempSchema);
                        this.m_authPropertyData.resetSchemaCache();
                        this.m_authPropertyData.setDirty();
                        this.m_tempSchema = "";
                        this.m_rowData.addElement(new VWTableItemWrapper(0, vwSchema));
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(vwSchema);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 547);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateSchema(Object aValue, int nRowIndex) {
        block11: {
            block10: {
                VWSchema vwSchema = null;
                try {
                    try {
                        block13: {
                            block12: {
                                if (aValue == null) break block12;
                                if (aValue instanceof String) break block13;
                            }
                            Object var7_4 = null;
                            break block10;
                        }
                        String schemaString = (String)aValue;
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null) {
                            vwSchema = (VWSchema)wrapper.getValue();
                        }
                        if (vwSchema != null) {
                            vwSchema.setSchema(schemaString);
                            this.m_authPropertyData.setDirty();
                            break block11;
                        } else {
                            this.m_tempSchema = schemaString;
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        if (this.m_authPropertyData != null) {
                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                        }
                        Object var7_6 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var7_5 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }
}

